/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr;

import com.ibm.hwmca.fw.connmgr.Connection;
import com.ibm.hwmca.fw.connmgr.HMCServerSocketFactory;
import com.ibm.hwmca.fw.util.Trace;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Hashtable;

public class AppletProxy
extends Thread {
    private InputStream fromApplet;
    private OutputStream toApplet;
    private InputStream fromTasklet;
    private OutputStream toTasklet;
    private AppletListener appletListener;
    private TaskletListener taskletListener;
    private Object appletSem = new Object();
    private Object appletOutSem = new Object();
    private boolean connectionEnded = false;
    private int token;
    public static final int APPLET_PORT = 9960;
    public static final byte TYPE_DATA = 1;
    public static final byte TYPE_FOCUS_EVENT = 2;
    private static final String TRACE_MASKT = "XFRMAPXT";
    private static final String TRACE_MASKF = "XFRMAPXF";
    private static final String TRACE_MASKD = "XFRMAPXD";
    private static final Object connectionSem = new Object();
    private static final Object PLACE_HOLDER = new Object();
    private static final long WAIT_TIME = 60000L;
    private static final Hashtable expectedTokens = new Hashtable();
    private static final Hashtable socketMap = new Hashtable();

    public AppletProxy(Connection conn) throws IOException {
        Trace.trace(TRACE_MASKT, "-> AppletProxy.<init>");
        Socket s = conn.getSocket();
        this.fromTasklet = s.getInputStream();
        this.toTasklet = s.getOutputStream();
        SecureRandom rand = new SecureRandom();
        this.token = rand.nextInt();
        Trace.trace(TRACE_MASKD, "AppletProxy: generated token " + this.token);
        expectedTokens.put(String.valueOf(this.token), PLACE_HOLDER);
        this.appletListener = new AppletListener();
        this.appletListener.start();
        this.taskletListener = new TaskletListener();
        this.taskletListener.start();
        Trace.trace(TRACE_MASKT, "<- AppletProxy.<init>");
    }

    public int getAppletPort() {
        return 9960;
    }

    public int getAppletToken() {
        return this.token;
    }

    public void injectData(byte[] b) throws IOException {
        this.injectData(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectData(byte[] b, int off, int len) throws IOException {
        if (this.connectionEnded) {
            throw new IOException("Connection ended");
        }
        Object object = this.appletOutSem;
        synchronized (object) {
            Trace.trace(TRACE_MASKT, "AppletProxy.injectData: injecting " + len + " bytes of data");
            this.toApplet.write(b, off, len);
        }
    }

    public void close() {
        this.appletListener.stopListening();
        this.taskletListener.stopListening();
        try {
            this.toApplet.close();
            this.fromApplet.close();
            this.toTasklet.close();
            this.fromTasklet.close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, e);
        }
    }

    public boolean connectionEnded() {
        return this.connectionEnded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForConnectionEnd() {
        while (!this.connectionEnded) {
            try {
                AppletProxy appletProxy = this;
                synchronized (appletProxy) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    static {
        new ConnectionListener().start();
    }

    static class ConnectionListener
    extends Thread {
        private ServerSocket serverSocket = null;

        public ConnectionListener() {
            try {
                this.serverSocket = HMCServerSocketFactory.getFactory().createServerSocket(9960);
            }
            catch (IOException e) {
                Trace.trace(AppletProxy.TRACE_MASKF, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Socket socket = this.serverSocket.accept();
                    Trace.trace(AppletProxy.TRACE_MASKD, "ConnectionListener: applet connected");
                    socket.setSoTimeout(5000);
                    InputStream in = socket.getInputStream();
                    int ch1 = in.read();
                    int ch2 = in.read();
                    int ch3 = in.read();
                    int ch4 = in.read();
                    if ((ch1 | ch2 | ch3 | ch4) < 0) {
                        throw new EOFException();
                    }
                    String t = String.valueOf(ch1 << 24 | ch2 << 16 | ch3 << 8 | ch4);
                    Trace.trace(AppletProxy.TRACE_MASKF, "ConnectionListener: applet gave us token " + t);
                    socket.setSoTimeout(0);
                    if (expectedTokens.remove(t) != null) {
                        socketMap.put(t, socket);
                        Trace.trace(AppletProxy.TRACE_MASKF, "ConnectionListener: waking up connection waiters");
                        Object object = connectionSem;
                        synchronized (object) {
                            connectionSem.notifyAll();
                            continue;
                        }
                    }
                    Trace.trace(AppletProxy.TRACE_MASKF, "ConnectionListener: applet gave us a bogus token.. closing connection.");
                    socket.close();
                    continue;
                }
                catch (IOException e) {
                    Trace.trace(AppletProxy.TRACE_MASKF, e);
                    continue;
                }
                break;
            }
        }
    }

    class TaskletListener
    extends Thread {
        private boolean listening = true;

        TaskletListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            block17: {
                Trace.trace(AppletProxy.TRACE_MASKT, "-> TaskletListener.run()");
                try {
                    Trace.trace(AppletProxy.TRACE_MASKD, "TaskletListener: waiting for the applet to connect");
                    object = AppletProxy.this.appletSem;
                    synchronized (object) {
                        long currTime = System.currentTimeMillis();
                        long waitTime = currTime + 60000L;
                        while (this.listening && AppletProxy.this.toApplet == null) {
                            try {
                                AppletProxy.this.appletSem.wait(waitTime - currTime);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            currTime = System.currentTimeMillis();
                            if (currTime < waitTime) continue;
                            throw new IOException("TaskletListener: timed out wait for applet to connect");
                        }
                    }
                    byte[] buffer = new byte[8192];
                    while (this.listening) {
                        Trace.trace(AppletProxy.TRACE_MASKD, "TaskletListener: waiting for data");
                        int bytesRead = AppletProxy.this.fromTasklet.read(buffer);
                        if (bytesRead != -1) {
                            Trace.trace(AppletProxy.TRACE_MASKD, "TaskletListener: read " + bytesRead + " bytes.. sending to applet");
                            Object object2 = AppletProxy.this.appletOutSem;
                            synchronized (object2) {
                                AppletProxy.this.toApplet.write(1);
                                AppletProxy.this.toApplet.write(bytesRead >> 8 & 0xFF);
                                AppletProxy.this.toApplet.write(bytesRead & 0xFF);
                                AppletProxy.this.toApplet.write(buffer, 0, bytesRead);
                                continue;
                            }
                        }
                        break;
                    }
                }
                catch (EOFException e) {
                    Trace.trace(AppletProxy.TRACE_MASKF, e);
                }
                catch (IOException e) {
                    if (!this.listening) break block17;
                    Trace.trace(AppletProxy.TRACE_MASKF, e);
                }
            }
            AppletProxy.this.connectionEnded = true;
            object = AppletProxy.this;
            synchronized (object) {
                AppletProxy.this.notifyAll();
            }
            Trace.trace(AppletProxy.TRACE_MASKT, "<- TaskletListener.run(): Thread ending");
        }

        void stopListening() {
            this.listening = false;
        }
    }

    class AppletListener
    extends Thread {
        private boolean listening = true;

        AppletListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Trace.trace(AppletProxy.TRACE_MASKT, "-> AppletListener.run()");
            try {
                Object object;
                Trace.trace(AppletProxy.TRACE_MASKD, "AppletListener: waiting for applet to connect");
                Socket socket = null;
                long currTime = System.currentTimeMillis();
                long waitTime = currTime + 60000L;
                do {
                    object = connectionSem;
                    synchronized (object) {
                        try {
                            connectionSem.wait(waitTime - currTime);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        currTime = System.currentTimeMillis();
                        if (currTime >= waitTime) {
                            throw new IOException("AppletListener: Timed out waiting for connection.");
                        }
                    }
                } while ((socket = (Socket)socketMap.remove(String.valueOf(AppletProxy.this.token))) == null);
                Trace.trace(AppletProxy.TRACE_MASKD, "AppletListener: applet connected");
                object = AppletProxy.this.appletSem;
                synchronized (object) {
                    AppletProxy.this.fromApplet = socket.getInputStream();
                    AppletProxy.this.toApplet = socket.getOutputStream();
                    AppletProxy.this.appletSem.notifyAll();
                }
                byte[] buffer = new byte[8192];
                while (this.listening) {
                    Trace.trace(AppletProxy.TRACE_MASKD, "AppletListener: waiting for data");
                    int bytesRead = AppletProxy.this.fromApplet.read(buffer);
                    if (bytesRead != -1) {
                        Trace.trace(AppletProxy.TRACE_MASKD, "AppletListener: read " + bytesRead + " bytes from applet.. sending to tasklet");
                        AppletProxy.this.toTasklet.write(buffer, 0, bytesRead);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                Trace.trace(AppletProxy.TRACE_MASKF, e);
            }
            AppletProxy.this.connectionEnded = true;
            AppletProxy appletProxy = AppletProxy.this;
            synchronized (appletProxy) {
                AppletProxy.this.notifyAll();
            }
            Trace.trace(AppletProxy.TRACE_MASKT, "<- AppletListener.run()");
        }

        void stopListening() {
            this.listening = false;
        }
    }
}

